/**
* \file: GstreamerVideoSinkConfig.h
*
* \version: 1.0
*
* \release: $Name:$
*
* Configuration of GstreamerVideoSink.
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
************************************************************************/
#ifndef BDCL_GSTREAMERVIDEOSINKCONFIG_H_
#define BDCL_GSTREAMERVIDEOSINKCONFIG_H_

#include <uspi/ConfigHandle.h>

namespace adit { namespace bdcl {
//Display Resolution.
#define VIDEO_WIDTH_800          800
#define VIDEO_HEIGHT_480         480

//Display Framerate.
#define VIDEO_DEFAULT_FRAMERATE      30
#define VIDEO_MAX_FRAMERATE          60

class GstreamerVideoSinkConfig : public uspi::ConfigHandle
{
public:
    GstreamerVideoSinkConfig() : mDisablePrio(false), mThreadPrio(0), mWidth(0), mHeight(0),
    mFrameRate(0), mPipeline("") { }

    bool ResultConfig(bool pipelineTest)
    {
        bool is_valid = true;

        if(pipelineTest)
        {
            mPipeline = getString("gstreamer-video-pipeline", &is_valid, Range(-1, INT_MAX));
        }
        mDisablePrio = getInt("disable-real-time-priority-video", &is_valid, Match(2, 0, 1), 0);
        mThreadPrio  = getInt("video-threads-real-time-priority", &is_valid, Range(0, INT_MAX), 42);

        mWidth = getInt("video-width", &is_valid, Range(0, INT_MAX), VIDEO_WIDTH_800);
        mHeight = getInt("video-height", &is_valid, Range(0, INT_MAX), VIDEO_HEIGHT_480);
        mFrameRate = getInt("video-fps", &is_valid, Range(0, VIDEO_MAX_FRAMERATE), VIDEO_DEFAULT_FRAMERATE);

        return is_valid;
    }

    bool mDisablePrio;
    int mThreadPrio;

    unsigned int mWidth;
    unsigned int mHeight;
    unsigned int mFrameRate;

    std::string mPipeline;

};

} } /*namespace adit { namespace bdcl { */

#endif /* BDCL_GSTREAMERVIDEOCONFIG_H_ */
